@echo off
setlocal EnableDelayedExpansion
chcp 65001 >nul 2>&1
title HiveMind - Installation

:: ─── Admin-Check ────────────────────────────────────────────────
net session >nul 2>&1
if %errorlevel% neq 0 (
    echo.
    echo  [!] HiveMind-Installer benoetigt Administratorrechte.
    echo      Rechtsklick auf diese Datei ^> "Als Administrator ausfuehren"
    echo.
    echo  Starte neu als Administrator...
    echo.
    powershell -Command "Start-Process '%~f0' -Verb RunAs -ArgumentList '%~dp0'"
    exit /b
)

:: ─── Variablen ──────────────────────────────────────────────────
set "INSTALL_DIR=%~dp0"
set "PYTHON_VERSION=3.12.8"
set "PYTHON_URL=https://www.python.org/ftp/python/%PYTHON_VERSION%/python-%PYTHON_VERSION%-amd64.exe"
set "PYTHON_INSTALLER=%TEMP%\python-%PYTHON_VERSION%-amd64.exe"
set "BUILDTOOLS_URL=https://aka.ms/vs/17/release/vs_BuildTools.exe"
set "BUILDTOOLS_INSTALLER=%TEMP%\vs_BuildTools.exe"

echo.
echo  ╔══════════════════════════════════════════════╗
echo  ║       🧠 HiveMind - Windows Installer        ║
echo  ║       Dezentrale P2P-AI fuer alle            ║
echo  ╚══════════════════════════════════════════════╝
echo.

:: ─── Schritt 1: Python prüfen / installieren ───────────────────
echo  [1/5] Pruefe Python...

where python >nul 2>&1
if %errorlevel% equ 0 (
    for /f "tokens=2 delims= " %%v in ('python --version 2^>^&1') do set "PY_VER=%%v"
    echo         Python !PY_VER! gefunden.

    :: Check if version is >= 3.10
    for /f "tokens=1,2 delims=." %%a in ("!PY_VER!") do (
        set "PY_MAJOR=%%a"
        set "PY_MINOR=%%b"
    )
    if !PY_MAJOR! geq 3 if !PY_MINOR! geq 10 (
        echo         [OK] Version ausreichend.
        goto :python_ok
    )
    echo         [!] Version zu alt, installiere neu...
)

echo.
echo         Python nicht gefunden oder zu alt.
echo         Lade Python %PYTHON_VERSION% herunter...
echo.

powershell -Command "[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; (New-Object Net.WebClient).DownloadFile('%PYTHON_URL%', '%PYTHON_INSTALLER%')"
if not exist "%PYTHON_INSTALLER%" (
    echo  [FEHLER] Python-Download fehlgeschlagen.
    echo           Bitte manuell installieren: https://python.org
    goto :error
)

echo         Installiere Python %PYTHON_VERSION% (silent)...
"%PYTHON_INSTALLER%" /quiet InstallAllUsers=1 PrependPath=1 Include_pip=1 Include_test=0

if %errorlevel% neq 0 (
    echo  [FEHLER] Python-Installation fehlgeschlagen.
    goto :error
)

:: Refresh PATH
set "PATH=C:\Program Files\Python312;C:\Program Files\Python312\Scripts;%PATH%"
set "PATH=%LOCALAPPDATA%\Programs\Python\Python312;%LOCALAPPDATA%\Programs\Python\Python312\Scripts;%PATH%"

:: Verify
where python >nul 2>&1
if %errorlevel% neq 0 (
    echo  [FEHLER] Python nicht im PATH gefunden nach Installation.
    echo           Bitte PC neustarten und Installer erneut ausfuehren.
    goto :error
)

echo         [OK] Python installiert.
del "%PYTHON_INSTALLER%" >nul 2>&1

:python_ok
echo.

:: ─── Schritt 2: Build Tools prüfen / installieren ──────────────
echo  [2/5] Pruefe C++ Build Tools...

where cl >nul 2>&1
if %errorlevel% equ 0 (
    echo         [OK] C++ Compiler gefunden.
    goto :buildtools_ok
)

:: Check if Visual Studio or Build Tools are installed
set "VS_FOUND=0"
if exist "C:\Program Files\Microsoft Visual Studio" set "VS_FOUND=1"
if exist "C:\Program Files (x86)\Microsoft Visual Studio" set "VS_FOUND=1"
if exist "%ProgramFiles(x86)%\Microsoft Visual Studio\Installer\vswhere.exe" (
    for /f "tokens=*" %%i in ('"%ProgramFiles(x86)%\Microsoft Visual Studio\Installer\vswhere.exe" -latest -property installationPath 2^>nul') do (
        if exist "%%i\VC\Tools\MSVC" set "VS_FOUND=1"
    )
)

if "!VS_FOUND!"=="1" (
    echo         [OK] Visual Studio / Build Tools gefunden.
    goto :buildtools_ok
)

echo.
echo         C++ Build Tools nicht gefunden.
echo         Lade Visual Studio Build Tools herunter...
echo         (Dies kann einige Minuten dauern)
echo.

powershell -Command "[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12; (New-Object Net.WebClient).DownloadFile('%BUILDTOOLS_URL%', '%BUILDTOOLS_INSTALLER%')"
if not exist "%BUILDTOOLS_INSTALLER%" (
    echo  [FEHLER] Build Tools Download fehlgeschlagen.
    echo           Bitte manuell installieren:
    echo           https://visualstudio.microsoft.com/visual-cpp-build-tools/
    goto :error
)

echo         Installiere C++ Build Tools (silent, dauert 5-10 Min)...
"%BUILDTOOLS_INSTALLER%" --quiet --wait --norestart --nocache ^
    --add Microsoft.VisualStudio.Workload.VCTools ^
    --add Microsoft.VisualStudio.Component.VC.Tools.x86.x64 ^
    --add Microsoft.VisualStudio.Component.Windows11SDK.22621 ^
    --includeRecommended

if %errorlevel% neq 0 if %errorlevel% neq 3010 (
    echo  [WARNUNG] Build Tools Installation moeglicherweise unvollstaendig.
    echo            Falls die naechsten Schritte fehlschlagen, bitte manuell installieren.
)

echo         [OK] Build Tools installiert.
del "%BUILDTOOLS_INSTALLER%" >nul 2>&1

:buildtools_ok
echo.

:: ─── Schritt 3: CMake prüfen / installieren ────────────────────
echo  [3/5] Pruefe cmake...

where cmake >nul 2>&1
if %errorlevel% equ 0 (
    echo         [OK] cmake gefunden.
    goto :cmake_ok
)

echo         cmake nicht gefunden, installiere via pip...
python -m pip install cmake --quiet 2>nul
if %errorlevel% equ 0 (
    echo         [OK] cmake installiert.
) else (
    echo         [WARNUNG] cmake konnte nicht installiert werden.
)

:cmake_ok
echo.

:: ─── Schritt 4: Python-Installer starten ────────────────────────
echo  [4/5] Starte HiveMind-Setup...
echo.

:: Check if install.py exists in same directory
if exist "%INSTALL_DIR%install.py" (
    python "%INSTALL_DIR%install.py"
) else (
    echo  [FEHLER] install.py nicht gefunden in %INSTALL_DIR%
    echo           Stelle sicher, dass alle Dateien entpackt wurden.
    goto :error
)

goto :done

:: ─── Fehlerbehandlung ───────────────────────────────────────────
:error
echo.
echo  ╔══════════════════════════════════════════════╗
echo  ║     [X] Installation fehlgeschlagen          ║
echo  ╚══════════════════════════════════════════════╝
echo.
echo  Pruefe die Fehlermeldungen oben.
echo  Bei Problemen: https://github.com/hivemind-ai/hivemind
echo.
pause
exit /b 1

:: ─── Fertig ─────────────────────────────────────────────────────
:done
echo.
echo  [5/5] Fertig!
echo.
pause
exit /b 0
