"""Chat plugin — core text conversation capability."""
from __future__ import annotations

from hivemind.plugins.base import Plugin, capability


class ChatPlugin(Plugin):
    name = "chat"
    version = "0.1.0"
    description = "Core text conversation"

    SYSTEM_PROMPT = (
        "Du bist ein hilfreicher AI-Assistent, Teil des HiveMind-Netzwerks. "
        "Antworte präzise und hilfreich. "
        "Du hast Zugang zu verschiedenen Fähigkeiten über Plugins."
    )

    @capability("Have a text conversation")
    async def respond(self, messages: list[dict], **kwargs) -> str:
        """Generate a response to chat messages using the local model."""
        if not self.node or not self.node.model or not self.node.model.loaded:
            return "⚠️ Kein Modell geladen. Bitte konfiguriere model.path in config.yaml."

        # Prepend system prompt if not present
        if not messages or messages[0].get("role") != "system":
            messages = [{"role": "system", "content": self.SYSTEM_PROMPT}] + messages

        return self.node.model.generate(messages, **kwargs)


PLUGIN_CLASS = ChatPlugin
