@echo off
setlocal EnableDelayedExpansion
title HiveMind - Installation

REM === Admin-Check ===
net session >nul 2>&1
if %errorlevel% neq 0 (
    echo.
    echo  [!] Administratorrechte benoetigt.
    echo      Rechtsklick ^> "Als Administrator ausfuehren"
    echo.
    echo  Starte neu als Administrator...
    powershell -Command "Start-Process '%~f0' -Verb RunAs"
    exit /b
)

REM === Variablen ===
set "INSTALL_DIR=%~dp0"
set "PY_VER=3.12.8"
set "PY_EXE=python-%PY_VER%-amd64.exe"
set "PY_URL=https://www.python.org/ftp/python/%PY_VER%/%PY_EXE%"
set "PY_DL=%TEMP%\%PY_EXE%"
set "BT_URL=https://aka.ms/vs/17/release/vs_BuildTools.exe"
set "BT_DL=%TEMP%\vs_BuildTools.exe"

echo.
echo  ====================================================
echo        HiveMind - Windows Installer
echo        Dezentrale P2P-AI fuer alle
echo  ====================================================
echo.

REM === Schritt 1: Python ===
echo  [1/5] Pruefe Python...

where python >nul 2>&1
if %errorlevel% neq 0 goto :install_python

for /f "tokens=2 delims= " %%v in ('python --version 2^>^&1') do set "FOUND_PY=%%v"
echo        Python !FOUND_PY! gefunden.

for /f "tokens=1,2 delims=." %%a in ("!FOUND_PY!") do (
    set "PY_MAJ=%%a"
    set "PY_MIN=%%b"
)

if !PY_MAJ! GEQ 3 (
    if !PY_MIN! GEQ 10 (
        echo        [OK] Version ausreichend.
        goto :python_ok
    )
)

:install_python
echo.
echo        Python nicht gefunden oder zu alt.
echo        Lade Python %PY_VER% herunter...

powershell -Command ^
  "[Net.ServicePointManager]::SecurityProtocol=[Net.SecurityProtocolType]::Tls12;^
  (New-Object Net.WebClient).DownloadFile('%PY_URL%','%PY_DL%')"

if not exist "%PY_DL%" (
    echo  [FEHLER] Python-Download fehlgeschlagen.
    echo           Bitte manuell: https://python.org
    goto :error
)

echo        Installiere Python %PY_VER% (silent)...
"%PY_DL%" /quiet InstallAllUsers=1 PrependPath=1 Include_pip=1

if %errorlevel% neq 0 (
    echo  [FEHLER] Python-Installation fehlgeschlagen.
    goto :error
)

set "PATH=C:\Program Files\Python312;C:\Program Files\Python312\Scripts;%PATH%"
set "PATH=%LOCALAPPDATA%\Programs\Python\Python312;%LOCALAPPDATA%\Programs\Python\Python312\Scripts;%PATH%"

where python >nul 2>&1
if %errorlevel% neq 0 (
    echo  [FEHLER] Python nicht im PATH. Bitte PC neustarten.
    goto :error
)

echo        [OK] Python installiert.
del "%PY_DL%" >nul 2>&1

:python_ok
echo.

REM === Schritt 2: Build Tools ===
echo  [2/5] Pruefe C++ Build Tools...

where cl >nul 2>&1
if %errorlevel% equ 0 (
    echo        [OK] C++ Compiler gefunden.
    goto :bt_ok
)

set "VS_FOUND=0"
if exist "C:\Program Files\Microsoft Visual Studio" set "VS_FOUND=1"
if exist "C:\Program Files (x86)\Microsoft Visual Studio" set "VS_FOUND=1"

if "!VS_FOUND!"=="1" (
    echo        [OK] Visual Studio gefunden.
    goto :bt_ok
)

echo.
echo        C++ Build Tools nicht gefunden.
echo        Lade Visual Studio Build Tools herunter...
echo        (Kann einige Minuten dauern)

powershell -Command ^
  "[Net.ServicePointManager]::SecurityProtocol=[Net.SecurityProtocolType]::Tls12;^
  (New-Object Net.WebClient).DownloadFile('%BT_URL%','%BT_DL%')"

if not exist "%BT_DL%" (
    echo  [FEHLER] Build Tools Download fehlgeschlagen.
    goto :error
)

echo        Installiere C++ Build Tools (5-10 Min)...
"%BT_DL%" --quiet --wait --norestart --nocache ^
  --add Microsoft.VisualStudio.Workload.VCTools ^
  --add Microsoft.VisualStudio.Component.VC.Tools.x86.x64 ^
  --add Microsoft.VisualStudio.Component.Windows11SDK.22621

echo        [OK] Build Tools installiert.
del "%BT_DL%" >nul 2>&1

:bt_ok
echo.

REM === Schritt 3: CMake ===
echo  [3/5] Pruefe cmake...

where cmake >nul 2>&1
if %errorlevel% equ 0 (
    echo        [OK] cmake gefunden.
    goto :cmake_ok
)

echo        Installiere cmake via pip...
python -m pip install cmake --quiet 2>nul
echo        [OK] cmake installiert.

:cmake_ok
echo.

REM === Schritt 4: HiveMind Setup ===
echo  [4/5] Starte HiveMind-Setup...
echo.

if exist "%INSTALL_DIR%install.py" (
    python "%INSTALL_DIR%install.py"
) else (
    echo  [FEHLER] install.py nicht gefunden in %INSTALL_DIR%
    goto :error
)

goto :done

REM === Fehler ===
:error
echo.
echo  ====================================================
echo        [X] Installation fehlgeschlagen
echo  ====================================================
echo.
echo  Pruefe die Fehlermeldungen oben.
echo.
pause
exit /b 1

REM === Fertig ===
:done
echo.
echo  [5/5] Fertig!
echo.
pause
exit /b 0
