# HiveMind — Dezentrale P2P-AI

## Vision
Eine dezentrale AI, die wie ein biologisches Gehirn funktioniert. Jeder Nutzer betreibt einen Node, der ein kleines spezialisiertes AI-Modell hostet. Zusammen bilden alle Nodes ein intelligentes Netzwerk — ohne zentrale Server, ohne zentrale Kontrolle.

## Kernprinzipien

1. **Kein Single Point of Failure** — Jede Fähigkeit existiert redundant auf vielen Nodes
2. **Graceful Degradation** — Netzwerk wird schlechter, nie kaputt
3. **Evolutionäre Optimierung** — Gute Konfigurationen verbreiten sich automatisch
4. **Sparse Activation** — Eine Anfrage aktiviert nur relevante Nodes
5. **Jeder Node ist gleichwertig** — Kein Node ist unverzichtbar

## Architektur

```
┌──────────────────────────────────────────┐
│              Zugang (Multi)              │
│  Desktop-App │ Telegram │ Signal │ Web   │
├──────────────────────────────────────────┤
│            Gateway / Bridge              │
│  (Messenger-Anbindung, API-Server)       │
├──────────────────────────────────────────┤
│            Plugin/Skill API              │
│  Web-Search │ Vision │ Audio │ Custom    │
├──────────────────────────────────────────┤
│           Lokaler AI-Node                │
│  • Kleines Basismodell (z.B. 7-8B)      │
│  • Spezialisierung durch Nutzung         │
│  • Lokaler semantischer Cache            │
│  • Fitness-Bewertung eigener Ergebnisse  │
├──────────────────────────────────────────┤
│          P2P Network Layer               │
│  • Node Discovery (DHT/mDNS)            │
│  • Anfrage-Routing nach Spezialisierung  │
│  • Evolutionärer Wissenstransfer         │
│  • Reputation & Trust-System             │
├──────────────────────────────────────────┤
│       Andere Nodes im Netzwerk           │
└──────────────────────────────────────────┘
```

## Tech-Stack

| Komponente | Technologie |
|---|---|
| Sprache | **Python 3.12+** |
| P2P | **libp2p** (py-libp2p) oder **ZeroMQ** + eigenes Discovery |
| Lokale AI | **llama-cpp-python** (GGUF-Modelle) |
| Plugins | Python-Module mit standardisierter API |
| Desktop-UI | **Textual** (TUI) oder **NiceGUI** (Web-basiert) |
| Messenger-Bridge | Telegram Bot API, Signal CLI, Matrix |
| Mobile | Kein eigener Client — Zugang über Messenger |
| API | **FastAPI** für lokale REST/WebSocket-Schnittstelle |

## Zugang — Desktop & Mobil

### Desktop (Heim-PC)
- HiveMind läuft als Daemon/Service
- Lokales Web-UI (NiceGUI auf localhost)
- Terminal-UI (Textual) als Alternative
- AI-Inferenz passiert hier (GPU/CPU)

### Mobil (unterwegs)
- **Kein eigener Mobile-Client nötig**
- Messenger-Bridge: Telegram, Signal, Matrix, Discord
- Der Heim-PC empfängt Nachrichten via Bot → verarbeitet → antwortet
- Wie bei OpenClaw: Messenger als Thin Client, Heim-PC als Backend
- Optional: Web-UI mit Passwort-Zugang von außen

### Messenger-Bridge Architektur
```
Handy (Telegram) 
    → Telegram API 
    → HiveMind Gateway (Heim-PC) 
    → Lokaler Node verarbeitet
    → Falls nötig: P2P-Netzwerk
    → Antwort zurück via Telegram
```

## P2P-Netzwerk

### Node Discovery
- **Lokal:** mDNS für Nodes im selben Netzwerk
- **Global:** DHT (Kademlia) über Bootstrap-Nodes
- **NAT-Traversal:** Hole-Punching, Relay-Nodes als Fallback

### Anfrage-Routing
1. Anfrage kommt rein → Embedding berechnen
2. Lokaler Cache prüfen → Hit? → Sofort antworten
3. Lokales Modell fähig? → Lokal verarbeiten
4. Sonst: DHT-Lookup → Welche Nodes sind für dieses Thema spezialisiert?
5. Anfrage an Top-3 Nodes senden → Beste Antwort auswählen

### Spezialisierung
- Jeder Node trackt: "Bei welchen Themen bin ich gut?"
- Fitness-Score pro Themenbereich (z.B. Mathe: 0.85, Medizin: 0.3)
- Scores werden im DHT publiziert
- Nodes mit ähnlicher Spezialisierung bilden Cluster

### Evolutionärer Wissenstransfer
```
Node A: "Meine Mathe-Fitness ist von 0.6 auf 0.9 gestiegen"
    → Broadcast: LoRA-Delta + Routing-Config
    → Andere Mathe-Nodes: Übernehmen & validieren
    → Netzwerk-weite Mathe-Fähigkeit steigt
```

- Nur **Deltas** werden geteilt, nicht ganze Modelle
- Empfänger validieren lokal bevor sie übernehmen
- Schlechte Updates werden automatisch verworfen (Fitness sinkt → Rollback)

## Plugin-System

### Core Plugins (mitgeliefert)
- `chat` — Text-Ein/Ausgabe
- `web_search` — Internet-Recherche
- `vision` — Bildverarbeitung (lokal oder via Netzwerk)
- `audio` — Speech-to-Text, Text-to-Speech
- `file` — Dateien lesen/schreiben

### Plugin API
```python
from hivemind.plugin import Plugin, capability

class WebSearchPlugin(Plugin):
    name = "web_search"
    version = "1.0.0"
    
    @capability("search the internet")
    async def search(self, query: str) -> str:
        """Durchsucht das Internet nach Informationen."""
        # Implementation
        pass
    
    @capability("fetch webpage content")
    async def fetch(self, url: str) -> str:
        """Lädt den Inhalt einer Webseite."""
        pass
```

### Netzwerk-Plugins
- Plugins können auch Netzwerk-Fähigkeiten bereitstellen
- Node mit GPU + Vision-Plugin → wird zum "Augen"-Node für andere
- Node mit Mikrofon + Audio-Plugin → wird zum "Ohren"-Node

## Redundanz & Resilienz

- Jede Fähigkeit auf mindestens 3 Nodes (konfigurierbar)
- Automatische Replikation: Wenn ein Themenbereich nur 1 Node hat → andere übernehmen
- Healthcheck: Nodes pingen sich gegenseitig
- Offline-Node → seine Spezialisierung wird umverteilt
- Online-Node → integriert sich, übernimmt Last

## Mobile Nodes — Sinnesorgane des Netzwerks

### Rolle
Desktop-Nodes sind das **Gehirn** (Inferenz, Cache, Spezialisierung). Mobile Nodes sind die **Sinnesorgane** (Sensoren, Datenlieferanten, leichte Aufgaben).

### Was Mobile Nodes beitragen
- **📍 Standort (GPS)** — Lokale Fragen von Nodes vor Ort beantworten, Echtzeit-Lagebild
- **📷 Kamera/Mikrofon** — Augen und Ohren des Netzwerks, liefern Bild-/Audio-Daten an GPU-Nodes
- **🌡️ Sensorik** — Beschleunigung, Kompass, Barometer, Licht, Näherung — Millionen verteilte Umweltsensoren
- **📊 Schwarmdaten** — Aggregierte, anonymisierte Muster (Verkehr, Wetter, Menschenmengen, Netzqualität)

### Lokale Fähigkeiten
- Winziges Modell (1-3B, quantisiert) für einfache Offline-Anfragen
- Vorverarbeitung: Bild/Audio lokal komprimieren bevor es ans Netzwerk geht
- Edge-Klassifizierung: "Ist das relevant?" lokal entscheiden → Bandbreite sparen

### Mobile Plugin-Beispiele
- **Live-Übersetzer** — Kamera auf Text → Netzwerk übersetzt
- **Umgebungs-Scout** — "Wie ist es gerade am Alexanderplatz?" → Handys dort antworten
- **Crowd-Sensing** — Anonymisierte Aggregation (Luftqualität, Lärmpegel, Wetter)

### Einschränkungen
- Keine schwere Inferenz (RAM/GPU-Limit)
- Nicht dauerhaft online (Akku, mobile Daten)
- Begrenzter Speicher → minimaler Cache
- Node-Rolle wird automatisch erkannt: Mobile = Sensor-Modus, Desktop = Compute-Modus

## Sicherheit

- **Ende-zu-Ende-Verschlüsselung** aller P2P-Kommunikation
- **Sandboxed Plugins** — kein direkter Systemzugriff ohne Erlaubnis
- **Reputation-System** — neue Nodes müssen Vertrauen aufbauen
- **Keine zentrale Datensammlung** — alles bleibt lokal oder verschlüsselt
- **Nutzer entscheidet** was geteilt wird und was lokal bleibt

## MVP — Roadmap

### Phase 1: Lokaler Node (v0.1)
- [ ] Python-Projekt-Setup (Poetry/uv)
- [ ] Lokales Modell laden (llama-cpp-python)
- [ ] Chat-Interface (Terminal)
- [ ] Einfaches Plugin-System
- [ ] Web-Search Plugin

### Phase 2: Messenger-Bridge (v0.2)  
- [ ] Telegram Bot Integration
- [ ] Gateway: Telegram ↔ Lokaler Node
- [ ] Mobile Nutzung möglich

### Phase 3: P2P-Netzwerk (v0.3)
- [ ] Node Discovery (mDNS lokal)
- [ ] Anfrage-Routing zwischen 2+ Nodes
- [ ] Semantischer Cache (geteilt)

### Phase 4: Spezialisierung (v0.4)
- [ ] Fitness-Tracking pro Node
- [ ] Themen-Routing via DHT
- [ ] Evolutionärer Wissenstransfer (LoRA-Deltas)

### Phase 5: Skalierung (v0.5+)
- [ ] NAT-Traversal / globales Netzwerk
- [ ] Reputation-System
- [ ] Vision/Audio Plugins
- [ ] Desktop-GUI

## Projektstruktur
```
hivemind/
├── hivemind/
│   ├── __init__.py
│   ├── node.py          # Lokaler AI-Node
│   ├── model.py         # Modell-Management (llama.cpp)
│   ├── cache.py         # Semantischer Cache
│   ├── router.py        # Anfrage-Routing
│   ├── network/
│   │   ├── __init__.py
│   │   ├── peer.py      # P2P-Verbindung
│   │   ├── discovery.py # Node Discovery
│   │   └── sync.py      # Wissenstransfer
│   ├── plugins/
│   │   ├── __init__.py
│   │   ├── base.py      # Plugin API
│   │   ├── chat.py      # Chat Plugin
│   │   └── web_search.py
│   ├── gateway/
│   │   ├── __init__.py
│   │   ├── telegram.py  # Telegram Bridge
│   │   ├── signal.py    # Signal Bridge
│   │   └── api.py       # REST/WS API
│   └── ui/
│       ├── __init__.py
│       ├── tui.py       # Terminal UI
│       └── web.py       # Web UI
├── plugins/             # Community Plugins
├── models/              # Lokale Modelle (GGUF)
├── config.yaml
├── pyproject.toml
└── README.md
```
