# 🧠 HiveMind — Dezentrale P2P-AI

Jeder Node ein Neuron. Zusammen ein Gehirn.

## Installation

### Geführte Installation (empfohlen)

```bash
# Python 3.10+ muss installiert sein
python3 install.py
```

Der Installer:
- Prüft dein System (Python, RAM, Speicherplatz)
- Lässt dich ein AI-Modell auswählen und lädt es herunter
- Installiert alle Abhängigkeiten automatisch
- Erstellt eine Desktop-Verknüpfung

Funktioniert auf **Linux** und **Windows**.

### Manuelle Installation

```bash
cd hivemind
python3 -m venv .venv
source .venv/bin/activate  # Linux
# .venv\Scripts\activate   # Windows
CMAKE_ARGS="-DGGML_NATIVE=OFF" pip install -e .
hivemind
```

## Konfiguration

Bearbeite `config.yaml`:

```yaml
model:
  path: "models/dein-modell.gguf"  # Pfad zum GGUF-Modell
  n_ctx: 4096
  n_gpu_layers: -1  # -1 = alles auf GPU

gateway:
  telegram:
    enabled: true
    token: "BOT_TOKEN"
  api:
    enabled: true
    port: 8420
```

## Befehle im Chat

- `/status` — Node-Status anzeigen
- `/plugins` — Geladene Plugins auflisten
- `/clear` — Gesprächsverlauf löschen
- `/quit` — Beenden

## API

```bash
# Status
curl http://localhost:8420/status

# Chat
curl -X POST http://localhost:8420/chat \
  -H "Content-Type: application/json" \
  -d '{"message": "Hallo!"}'
```

## Architektur

```
User → TUI / Telegram / API
         ↓
    HiveMind Node
    ├── Local Model (llama.cpp)
    ├── Semantic Cache
    ├── Plugin System
    └── P2P Network (Phase 3)
```

## Plugins

Plugins erweitern die Fähigkeiten des Nodes:

- `chat` — Text-Konversation
- `web_search` — Internet-Recherche

Eigene Plugins in `plugins/` ablegen. Siehe `hivemind/plugins/base.py` für die API.

## Roadmap

- [x] Phase 1: Lokaler Node + Chat + Plugins + API
- [x] Phase 2: Telegram Bridge
- [x] Phase 3: P2P-Netzwerk
- [x] Phase 4: Spezialisierung & Evolution
- [ ] Phase 5: Mobile Nodes
